/*
 * MX-Multiuser DOS Password Control
 * Copyright (c) 1992 The MX-Multiuser DOS Project.  All rights reserved.
 * chris@uuczar.dearborn.mi.us
 *
 * Main code for this program was written by Robert Morse
 * (uunet!destroyer!medar!rmsun!rmorse)
 *
 * Program: PASSWD (passwd.c)
 * Version: 1.0 (OS Version 1.11)
 * Syntax: passwd [new-password]
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by
 *	The MX-Multiuser DOS Project and other contributors.
 * 4. Neither the name of the author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY MX-MDOS PROJECT AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE MX-MDOS PROJECT OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>		/* Include info needed for I/O */

char *passwd="/mxdos/mail/passwd.f";   /* Defines our password file */

/* On some DOS compilers it should be */
/* char *passwd = "\\mxdos\\mail\\passwd.f"; */

/* Check if TRUE and FALSE have been defined if not define them */
#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif 

main(argc,argv)
int argc;
char *argv[];

{
	char tpasswd[20],gpasswd[20];  /* 8 chars plus the NULL */
	FILE *passwdf;
	int correctp;
	correctp = FALSE;

	if ( argc == 2 ) /* At burger king, what you want is what you get! */
	{
		if ( (passwdf = fopen(passwd,"w")) == (FILE *)NULL) /* Write err */
		{
			fprintf(stderr,"passwd : Error opening password file for writing\n",passwdf);
			exit(0);
		}
		fprintf(passwdf,"%s",argv[1]);
		fclose(passwdf);
		printf("Password changed.\n");
		exit(0);
	}

	if ( argc != 1 ) /* Do they know what to do? */
	{
		fprintf(stderr,"Usage: passwd [new-system-password]\n");
		exit(0);
	}

	if ( (passwdf = fopen(passwd,"r")) == (FILE *)NULL) /* Read err */
	{
		fprintf(stderr,"passwd : Error opening password file for reading\n",passwdf);
		exit(0);
	}
	
	while ( !correctp )
	{
		fscanf(passwdf,"%20s",tpasswd); /* Get passwd from file passwdf */	
		printf("\nPassword: "); /* Ask for the password */
		fscanf(stdin,"%20s",gpasswd); /* Get the password from input */
	
		if ( strcmp( tpasswd, gpasswd) == 0) 
		{
			correctp = TRUE;
			fclose(passwdf);
			exit(1);
		}

		printf("Incorrect password"); /* Sorry dude */
	}
}
